<?php

namespace App\Http\Controllers\API\Therapists;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Broadcast;
use App\Http\Requests\API\Therapists\TherapistBroadcasts\CreateRequest;
use App\Http\Resources\API\BroadcastsResource;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistBroadcastsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
        $this->middleware(['api','auth:api','verified','api_setting']);
        $this->middleware('therapist.api');
      // $this->middleware('permission:therapist_broadcasts.index');
      // $this->middleware('permission:therapist_broadcasts.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_broadcasts.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_broadcasts.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_broadcasts.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_broadcasts.import',['only' => ['import']])
      // $this->middleware('permission:therapist_broadcasts.update|therapist_broadcasts.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist = auth()->user()->therapist;
    if($req != null){
      $therapist_broadcasts =  $therapist->therapist_broadcasts()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_broadcasts =  $therapist_broadcasts->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_broadcasts =  $therapist_broadcasts->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_broadcasts = $therapist_broadcasts->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_broadcasts = $therapist_broadcasts->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_broadcasts = $therapist_broadcasts->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_broadcasts = $therapist_broadcasts->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_broadcasts = $therapist_broadcasts->get();
        return $therapist_broadcasts;
      }
      $totalTherapistCertifications = $therapist_broadcasts->count();
      $therapist_broadcasts = $therapist_broadcasts->paginate($req->perPage);
      $therapist_broadcasts = BroadcastsResource::collection($therapist_broadcasts)->response()->getData(true);

      return $therapist_broadcasts;
    }
    $therapist_broadcasts = BroadcastsResource::collection($therapist->therapist_broadcasts()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_broadcasts;
  }

  /********* FETCH ALL TherapistCertifications ***********/
    public function index()
    {
        $therapist_broadcasts =  $this->getter();
        $response = generateResponse($therapist_broadcasts,count($therapist_broadcasts['data']) > 0 ? true:false,'TherapistCertifications Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistCertifications FOR Search ***********/
   public function filter(Request $request){
     $therapist_broadcasts = $this->getter($request);
     $response = generateResponse($therapist_broadcasts,count($therapist_broadcasts['data']) > 0 ? true:false,'Filter TherapistCertifications Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistMedia ***********/
    public function store(CreateRequest $request)
    {
      $therapist = auth()->user()->therapist;
      try{
        DB::beginTransaction();
        $request->merge(['created_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        $data['image'] = uploadFile($request,'image','therapist_broadcasts');
        $data['audio'] = uploadFile($request,'audio','therapist_broadcasts');
        $data['video'] = uploadFile($request,'video','therapist_broadcasts');
        $therapist_broadcast = $therapist->therapist_broadcasts()->create($data);
        $therapist_broadcast->slug = Str::slug($therapist_broadcast->name . ' ' . $therapist_broadcast->id, '-');
        $therapist_broadcast->save();
        $therapist_broadcast->tags()->sync($request->tag_ids);
        DB::commit();
        $therapist_broadcast = $therapist->therapist_broadcasts()->withAll()->find($therapist_broadcast->id);
        $therapist_broadcast = new BroadcastsResource($therapist_broadcast);
      $response = generateResponse($therapist_broadcast,true ,'TherapistCertifications Created Successfully',null,'collection');
      return response()->json($response, 200);
    }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show(Broadcast $therapist_broadcast)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_broadcast->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_broadcast = $therapist->therapist_broadcasts()->withAll()->find($therapist_broadcast->id);
        if($therapist_broadcast){
          $therapist_broadcast = new BroadcastsResource($therapist_broadcast);
          $response = generateResponse($therapist_broadcast,true,'TherapistMedia Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistMedia Not Found',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistMedia ***********/
    public function update(CreateRequest $request, Broadcast $therapist_broadcast)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if($therapist_broadcast->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadFile($request,'image','therapist_broadcasts',$therapist_broadcast->image);
        } else {
            $data['image'] = $therapist_broadcast->image;
        }

        if ($request->audio) {
            $data['audio'] = uploadFile($request,'audio','therapist_broadcasts');
        } else {
            $data['audio'] = $therapist_broadcast->audio;
        }

        if ($request->video) {
            $data['video'] = uploadFile($request,'video','therapist_broadcasts');
        } else {
            $data['video'] = $therapist_broadcast->video;
        }
        $data['slug'] = Str::slug($data['name'] . ' ' . $therapist_broadcast->id, '-');
        $therapist_broadcast->update($data);
         $therapist_broadcast->tags()->sync($request->tag_ids);
        DB::commit();
        $therapist_broadcast = $therapist->therapist_broadcasts()->withAll()->find($therapist_broadcast->id);
        $therapist_broadcast = new BroadcastsResource($therapist_broadcast);
        $response = generateResponse($therapist_broadcast,true,'TherapistMedia Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
        catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }

    /********* UPDATE TherapistMedia Status***********/
    public function updateStatus(Request $request,Broadcast $therapist_broadcast){
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_broadcast->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_broadcast->update([
          'is_active' => $therapist_broadcast->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistMedia Status Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }


    /********* DELETE TherapistMedia ***********/
    public function destroy(Request $request,Broadcast $therapist_broadcast)
    {
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_broadcast->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
          if($therapist_broadcast->trashed()) {
            $response = generateResponse(null,false ,'Already in Trash',null,'collection');
            return response()->json($response, 404);
          }
          else{
            $therapist_broadcast->delete();
          }
          $response = generateResponse(null,true,'TherapistMedia Deleted Successfully',null,'object');
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /*********Permanently DELETE TherapistMedia ***********/
    public function destroyPermanently(Request $request,$therapist_broadcast)
    {
      try{
        $therapist= auth()->user()->therapist;
        $therapist_broadcast = $therapist->therapist_broadcasts()->withTrashed()->find($therapist_broadcast);
        if($therapist_broadcast){
            if($therapist_broadcast->therapist_id != $therapist->id){
              $response = generateResponse(null,false ,'Not Found',null,'collection');
              return response()->json($response, 404);
            }
          if ($therapist_broadcast->trashed()) {
            $therapist_broadcast->forceDelete();
            $response = generateResponse(null,true,'TherapistMedia Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistMedia is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistMedia not found',null,'object');
        }
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /********* Restore TherapistMedia ***********/
    public function restore(Request $request,$therapist_broadcast)
    {
      $therapist= auth()->user()->therapist;
      $therapist_broadcast = $therapist->therapist_broadcasts()->withTrashed()->find($therapist_broadcast);
          if ($therapist_broadcast->trashed()) {
            $therapist_broadcast->restore();
            $response = generateResponse(null,true,'TherapistMedia Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistMedia is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
